<?php

function sm_register_shortcode_handler_sm_numbered_thumbnail() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_numbered_thumbnail extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_numbered_thumbnail_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_numbered_thumbnail', 'sm_numbered_thumbnail_func' );
	}
}

function sm_numbered_thumbnail_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);

	return sm_render_view( 'numbered-thumbnail', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Numbered Thumbnail', 'semona-extension' ),
	'base' => 'sm_numbered_thumbnail',
	'class' => '',
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-numbered_thumbnail.png',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Numbered Thumbnail Image', 'semona-extension' ),
	'params' => array(
		array(
			'type' => 'attach_image',
			'heading' => esc_html__( 'Image', 'semona-extension' ),
			'param_name' => 'image',
			'admin_label' => true,
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Image Number', 'semona-extension' ),
			'param_name' => 'number',
			'value' => '',
			'admin_label' => true,
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Number Circle Background Color', 'semona-extension' ),
			'param_name' => 'bg_color',
			'description' => esc_html__( 'Select background color of numbered circle.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'value' => sm_get_preset_colors_array( false )
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Background Color', 'semona-extension' ),
			'param_name' => 'custom_bg_color',
			'description' => esc_html__( 'Select custom background color of numbered circle.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'bg_color',
				'value' => array( 'custom' )
			),
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Number Circle Border Color', 'semona-extension' ),
			'param_name' => 'border_color',
			'description' => esc_html__( 'Select border color of numbered circle.', 'semona-extension' ),
			'param_holder_class' => 'sm-preset-color-dropdown',
			'value' => sm_get_nt_number_border_colors_array()
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Custom Color', 'semona-extension' ),
			'param_name' => 'custom_border_color',
			'description' => esc_html__( 'Select custom border color of numbered circle.', 'semona-extension' ),
			'dependency' => array(
				'element' => 'border_color',
				'value' => array( 'custom' )
			),
		),
		sm_css_animation_class(),
		sm_css_animation_delay(),
		sm_extra_class()
	)
) );
